(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     52588,       1492]*)
(*NotebookOutlinePosition[     53535,       1526]*)
(*  CellTagsIndexPosition[     53427,       1519]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Fundamentos Pr\[AAcute]ctica 4
Ecuaciones diferenciales. Transformada de Laplace. Funciones \
anal\[IAcute]ticas de una matriz cuadrada.\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Comandos b\[AAcute]sicos para resolver ecuaciones diferenciales", \
"Section"],

Cell[CellGroupData[{

Cell["El comando DSolve[ ]", "Subsubsection"],

Cell[TextData[{
  "Este comando es uno de los m\[AAcute]s potentes de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y puede resolver de forma simb\[OAcute]lica una gran cantidad de EDOs. Su \
sintaxis es"
}], "Text"],

Cell["\<\
DSolve[listadeEDOs(y)CondicionesIniciales, listadeFunciones, \
VariableIndependiente]\
\>", "Text",
  TextAlignment->Center],

Cell[TextData[{
  "e intenta resolver simb\[OAcute]licamente las EDO(s) con condiciones \
iniciales dadas en ",
  StyleBox["listadeEDOs(y)CondicionesIniciales",
    FontSlant->"Italic"],
  " para las funciones en ",
  StyleBox["listadeFunciones",
    FontSlant->"Italic"],
  ". La variable independiente es ",
  StyleBox["VariableIndependiente",
    FontSlant->"Italic"],
  ". Para el caso de una sola EDO sin condiciones iniciales y una sola funci\
\[OAcute]n inc\[OAcute]gnita, los argumentos primero y segundo pueden ir sin \
llaves de lista. Cuando este comando tiene \[EAcute]xito, su salida es una \
lista de listas de reglas de sustituci\[OAcute]n (como Solve[ ]). Es \
frecuente que en la soluci\[OAcute]n intervengan ",
  StyleBox["funciones especiales",
    FontSlant->"Italic"],
  " ",
  "como, por ejemplo, la funci\[OAcute]n seno integral, funciones de Bessel, \
funciones de Airy y otras (todas ellas documentadas en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Adem\[AAcute]s, dependiendo de c\[OAcute]mo representemos las \
funciones, la respuesta dada por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede presentar algunos cambios formales. Veamos algunos ejemplos."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(sol1 = DSolve[\(y'\)[x] \[Equal] 3  y[x], y[x], x]\), " ", 
        RowBox[{"(*", " ", 
          RowBox[{
            StyleBox["una",
              FontSlant->"Italic"], " ", "ecuaci\[OAcute]n", " ", "sin", " ", 
            "condiciones", " ", "iniciales", " ", "y", " ", 
            StyleBox["una",
              FontSlant->"Italic"], " ", "funci\[OAcute]n", " ", 
            "inc\[OAcute]gnita", " ", "por", " ", "lo", " ", "que", " ", 
            "podemos", " ", "prescindir", " ", "de", " ", "las", " ", 
            "llaves", " ", "en", " ", "los", " ", "dos", " ", "primeros", " ",
             "argumentos"}], " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", \(sol2 = 
          DSolve[\(y'\)[x] \[Equal] 3  y[x], y, x]\)}], 
      " ", \( (*\ 
        observa\ que\ hemos\ representado\ la\ funci\[OAcute]n\ por\ "\<y\>"\ \
en\ vez\ de\ "\<y[x]\>"\ *) \)}]], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nos dice en ambos casos que la soluci\[OAcute]n de la ED es la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y[x] = C[1] e\^\(3  x\)\)]],
  " donde C[1]  representa una constante arbitraria.",
  Cell[BoxData[
      FormBox[Cell[""], TraditionalForm]]],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " introduce tantas constantes como el orden de la ED. Cuando se especifican \
condiciones iniciales el n\[UAcute]mero de constantes se va reduciendo. \
Observa que, en ambos casos, la soluci\[OAcute]n es una lista de listas de \
reglas de sustituci\[OAcute]n (en este caso una \[UAcute]nica regla de \
sustituci\[OAcute]n porque s\[OAcute]lo hay una funci\[OAcute]n \
inc\[OAcute]gnita). La diferencia entre una y otra forma de presentar la \
soluci\[OAcute]n est\[AAcute] en su comportamiento cuando se aplican reglas \
de sustituci\[OAcute]n. Mientras que ",
  StyleBox["sol1",
    FontWeight->"Bold"],
  " solamente sustituye y[x] por su valor, ",
  StyleBox["sol2",
    FontWeight->"Bold"],
  " puede sustituir valores como y[0] o derivadas y'[x]. Observa la \
diferencia."
}], "Text"],

Cell[BoxData[{
    \(y[x] + y[0] + \(y'\)[x] /. sol1\ [\([1]\)] (*\ 
      la\ regla\ de\ sustituci\[OAcute]n\ que\ contiene\ sol1\ solamente\ se\ \
aplica\ a\ y[x]\ *) \), "\[IndentingNewLine]", 
    \(y[x] + y[0] + \(y'\)[x] /. sol2[\([1]\)]\), "\[IndentingNewLine]", 
    \( (*\ 
      la\ regla\ de\ sustituci\[OAcute]n\ que\ contiene\ sol2\ se\ aplica\ en\
\ todos\ los\ casos\ *) \)}], "Input"],

Cell["Si sustuimos la soluci\[OAcute]n en la ED original obtenemos True.", \
"Text"],

Cell[BoxData[
    \(\(\(\(y'\)[x] \[Equal] 3  y[x]\)\(/.\)\(sol2[\([1]\)]\)\(\ \)\( (*\ 
        para\ esto\ solamente\ podemos\ usar\ sol2\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Por tanto, si quieres sustituir directamente la soluci\[OAcute]n \
proporcionada por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de una ED para hacer c\[AAcute]lculos con ella, es preferible la segunda \
forma a la primera. Salvo este detalle, usar una u otra forma de presentar la \
soluci\[OAcute]n es cuesti\[OAcute]n de gusto."
}], "Text"],

Cell["\<\
La soluci\[OAcute]n antes obtenida no toma valores num\[EAcute]ricos porque \
depende de C[1] y no es posible representarla gr\[AAcute]ficamente ni hacer c\
\[AAcute]lculos num\[EAcute]ricos con ella. Solamente podemos hacer \
representaciones gr\[AAcute]ficas o c\[AAcute]lculos num\[EAcute]ricos con \
soluciones particulares de una ED. Debes tener en cuenta que no es posible \
asignar directamente valores num\[EAcute]ricos a las constantes porque son s\
\[IAcute]mbolos protegidos, aunque podemos hacerlo con reglas de sustituci\
\[OAcute]n apropiadas. En general, la forma usual de obtener una soluci\
\[OAcute]n particular es especificar condiciones iniciales. \
\>", "Text"],

Cell[BoxData[
    RowBox[{
    "sol", "=", \(DSolve[{\(y'\)[x] \[Equal] 3  y[x], y[1] \[Equal] 1}, y[x], 
        x]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{
          StyleBox["una",
            FontSlant->"Italic"], " ", "ecuaci\[OAcute]n", " ", "con", " ", 
          "condiciones", " ", "iniciales", " ", "y", " ", 
          StyleBox["una",
            FontSlant->"Italic"], " ", "funci\[OAcute]n", " ", 
          "inc\[OAcute]gnita", " ", "por", " ", "lo", " ", "que", " ", "no", 
          " ", "podemos", " ", "prescindir", " ", "de", " ", "las", " ", 
          "llaves", " ", "en", " ", "el", " ", "primer", " ", "argumento"}], 
        " ", "*)"}]}]], "Input"],

Cell[TextData[{
  "Para hacer c\[AAcute]lculos y representaciones gr\[AAcute]ficas es \
conveniente definir la soluci\[OAcute]n obtenida en la forma usual en que se \
definen las funciones en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(y[x_] = y[x] /. sol[\([1]\)]\), " ", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
          
          RowBox[{\(Aunque\ y[
                x]\ se\ repite\ en\ los\ dos\ lados\ de\ la\ \
definici\[OAcute]n\), ",", " ", 
            RowBox[{
            "no", " ", "entramos", " ", "en", " ", "un", " ", "bucle", " ", 
              "infinito", " ", "porque", " ", "Mathematica", " ", "ejecuta", 
              " ", 
              StyleBox["primero",
                FontSlant->"Italic"], " ", "el", " ", "comando", " ", "de", 
              " ", "sustituci\[OAcute]n", " ", "en", " ", "el", " ", "lado", 
              " ", "de", " ", "la", " ", "derecha"}], ",", 
            " ", \(con\ lo\ cual\ sustituye\ y[
                x]\ por\ la\ soluci\[OAcute]n\ obtenida\), ",", " ", 
            RowBox[{"y", " ", 
              StyleBox["despu\[EAcute]s",
                FontSlant->"Italic"], " ", "asigna", " ", "la", " ", 
              "funci\[OAcute]n", " ", \(y[x]\), " ", "a", " ", "esta", " ", 
              "soluci\[OAcute]n"}]}], " ", "*)"}]}], " "}]], "Input"],

Cell[BoxData[
    \(\(Plot[y[x], {x, \(-1\), 1}, PlotStyle \[Rule] Hue[ .5]];\)\)], "Input",\

  CellTags->"GraphicsArray"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede resolver EDLs y sistemas de EDLs con coeficientes constantes."
}], "Text"],

Cell[BoxData[{
    \(\(ecuacion = \(y''''\)[t] - 5 \( y'''\)[t] + 10 \( y''\)[t] - 
            10 \( y'\)[t] + 4  y[t] \[Equal] 
          Cos[t];\)\), "\[IndentingNewLine]", 
    \(y[t] /. \(DSolve[ecuacion, y, t]\)[\([1]\)]\)}], "Input"],

Cell[TextData[{
  "En este caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha podido calcular de forma simb\[OAcute]lica exacta las ra\[IAcute]ces \
del polinomio caracter\[IAcute]stico, que proporcionan la soluci\[OAcute]n \
general de la ED homog\[EAcute]nea, y tambi\[EAcute]n ha podido calcular una \
soluci\[OAcute]n particular de la ED completa. La soluci\[OAcute]n obtenida \
es la suma de ambas."
}], "Text"],

Cell[BoxData[
    \(\(\(\(y''''\)[t] - 5 \( y'''\)[t] + 10 \( y''\)[t] - 10 \( y'\)[t] + 
            4  y[t] \[Equal] 0 /. 
        y \[Rule] 
          Function[{t}, \[ExponentialE]\^t\ C[
                  3] + \[ExponentialE]\^\(2\ t\)\ C[
                  4] + \[ExponentialE]\^t\ C[2]\ Cos[
                  t] + \[ExponentialE]\^t\ C[1]\ Sin[
                  t]]\)\(//\)\(Simplify\)\(\ \)\( (*\ 
        comprobamos\ que\ la\ primera\ parte\ de\ la\ soluci\[OAcute]n\ \
obtenida\ es\ soluci\[OAcute]n\ de\ la\ ED\ homog\[EAcute]nea\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(\(\(ecuacion /. 
        y \[Rule] 
          Function[{t}, 
            1\/20\ \((Cos[t] - 3\ Cos[t]\ Cos[2\ t] - 3\ Sin[t] - 
                  Cos[2\ t]\ Sin[t] + Cos[t]\ Sin[2\ t] - 
                  3\ Sin[t]\ Sin[2\ t])\)]\)\(//\)\(Simplify\)\(\ \)\( (*\ 
        comprobamos\ que\ la\ segunda\ parte\ de\ la\ soluci\[OAcute]n\ \
obtenida\ es\ soluci\[OAcute]n\ de\ la\ ED\ completa\ *) \)\)\)], "Input"],

Cell["\<\
Si cambiamos un poquito lo anterior pueden pasar cosas como esta.\
\>", "Text"],

Cell[BoxData[
    \(y[t] /. \(DSolve[\(y''''\)[t] - 5 \( y'''\)[t] + 10 \( y''\)[t] - 
              10 \( y'\)[t] + 4  y[t] \[Equal] Exp[t^2], y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "No es posible expresar la soluci\[OAcute]n por medio de funciones \
elementales y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usa la funci\[OAcute]n especial Erfi[ ]. La parte homog\[EAcute]nea de la \
soluci\[OAcute]n permanece igual. \nLa soluci\[OAcute]n general de una EDL \
homog\[EAcute]nea con coeficientes constantes puede presentarse de formas \
diferentes dependiendo de que las ra\[IAcute]ces del polinomio caracter\
\[IAcute]stico sean m\[AAcute]s o menos f\[AAcute]ciles de expresar por medio \
de radicales (cuando ello sea posible). "
}], "Text"],

Cell[BoxData[
    \(\(DSolve[\(y''''\)[t] + 5 \( y'''\)[t] + 10 \( y''\)[t] - 
            10 \( y'\)[t] + 4  y[t] \[Equal] 0, y, t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "En este caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede calcular de forma simb\[OAcute]lica todas las ra\[IAcute]ces del \
polinomio carecter\[IAcute]stico porque \[EAcute]ste es de grado 4, pero \
estas ra\[IAcute]ces son muy complicadas y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prefiere representarlas en la forma anterior. Si queremos que las muestre \
de forma expl\[IAcute]cita hay que ped\[IAcute]rlo con el comando ToRadicals[ \
]."
}], "Text"],

Cell[BoxData[
    \(ToRadicals[%]\)], "Input"],

Cell[TextData[{
  "Cuando las ra\[IAcute]ces del polinomio caracter\[IAcute]stico no pueden \
calcularse por medio de radicales, cosa frecuente cuando su grado es mayor o \
igual que 5, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las deja indicadas de forma simb\[OAcute]lica. Para estos casos es \
preferible usar el comando NDSolve[ ] que veremos m\[AAcute]s adelante."
}], "Text"],

Cell[BoxData[
    \(\(\(\(DSolve[\(y'''''\)[t] - 5 \( y''\)[t] + 4 \( y'\)[t] - 
            2  y[t] \[Equal] 0, y, t]\)[\([1]\)] (*\ 
      las\ ra\[IAcute]ces\ de\ un\ polinomio\ de\ grado\ 5\ no\ pueden\ \
expresarse, \ en\ general, \ 
      por\ medio\ de\ radicales\ *) \[IndentingNewLine]
    ToRadicals[%]\)\( (*\ 
      en\ este\ caso\ este\ comando\ no\ hace\ nada\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Tambi\[EAcute]n podemos, para el caso de ED lineales con coeficientes \
constantes, introducir alg\[UAcute]n valor aproximado en nuestra ED y as\
\[IAcute] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula num\[EAcute]ricamente las ra\[IAcute]ces del polinomio caracter\
\[IAcute]sitco. Observa la diferencia entre trabajar simb\[OAcute]licamente y \
hacerlo num\[EAcute]ricamente."
}], "Text"],

Cell[BoxData[
    \(\(DSolve[\(y'''''\)[t] - 5*\(y''\)[t] + 4 \( y'\)[t] - 2  y[t] \[Equal] 
          0.0, y, t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Hemos hecho un peque\[NTilde]o cambio: hemos sustituido 0 por 0.0, pero \
ahora Mathematica proporciona la soluci\[OAcute]n de forma expl\[IAcute]cita. \
Naturalmente, esta soluci\[OAcute]n es la que interesa a efectos de \
c\[AAcute]lculo pero, matem\[AAcute]ticamente, es una soluci\[OAcute]n \
aproximada de nuestra ED y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue siempre entre c\[AAcute]lculos simb\[OAcute]licos (es decir, \
matem\[AAcute]ticamente exactos) y c\[AAcute]lculos aproximados (es decir, \
\"",
  StyleBox["exactos\"",
    FontSlant->"Italic"],
  " desde un punto de vista pr\[AAcute]ctico)."
}], "Text"],

Cell["\<\
Para EDLs con coeficientes no constantes las cosas pueden complicarse. Aqu\
\[IAcute] tienes algunos ejemplos.\
\>", "Text"],

Cell["\<\
DSolve[y'[x] - x y[x] == 1, y[x], x]
DSolve[x y''[x] + y[x] == 0, y[x], x]
DSolve[x^2 y''[x] + y[x] == 0, y[x], x]
DSolve[y''[x] - x y[x] == 0, y[x], x]\
\>", "Input",
  CellTags->"S3.5.10"],

Cell["\<\
Salvo la tercera ecuaci\[OAcute]n cuya soluci\[OAcute]n general puede \
expresarse por medio de funciones elementales, en los dem\[AAcute]s casos las \
soluciones hacen intervenir funciones especiales.\
\>", "Text"],

Cell["\<\
Para resolver sistemas de EDs hay que escribir todas las ecuaciones y las \
condiciones iniciales si las hay.\
\>", "Text"],

Cell[BoxData[
    \(\(\(DSolve[{\(x'\)[t] + \(y'\)[t] + y[t] == 
          1, \(x'\)[t] - \(y'\)[t] - x[t] \[Equal] 1, x[0] \[Equal] 0, 
        y[0] \[Equal] 0}, {x, y}, t]\[IndentingNewLine]
    {\(x'\)[t] + \(y'\)[t] + y[t] == 1, \(x'\)[t] - \(y'\)[t] - x[t] \[Equal] 
            1, x[0] \[Equal] 0, y[0] \[Equal] 0} /. % // 
      Simplify\)\(\ \)\( (*\ 
      comprobamos\ la\ soluci\[OAcute]n\ obtenida\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Clear["\<@\>"]\)\( (*\ 
      limpia\ todos\ los\ nombres\ antes\ usados\ que\ contengan\ solamente\ \
min\[UAcute]sculas\ o\ n\[UAcute]meros, \ 
      como\ sol1\ o\ sol\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy f\[AAcute]cil estudiar la dependencia de la soluci\[OAcute]n de \
una ED con respecto a las condiciones iniciales. Para ello basta con que \
definamos la soluci\[OAcute]n de forma apropiada. Observa el siguiente \
ejemplo."
}], "Text"],

Cell[BoxData[
    \(y[a_, b_, t_] =  (*\ 
        la\ definici\[OAcute]n\ de\ esta\ funci\[OAcute]n\ incluye\ su\ \
dependencia\ respecto\ de\ las\ condiciones\ iniciales; \ 
        para\ ello\ "\<a\>"\ y\ "\<b\>"\ son\ consideradas\ como\ variables\ \
de\ la\ funci\[OAcute]n\ *) \ 
      y[t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + 2  y[t] \[Equal] 0, 
              y[0] \[Equal] a, \(y'\)[0] \[Equal] b}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell["\<\
Ahora podemos usar esta funci\[OAcute]n para representar cualquier soluci\
\[OAcute]n particular dando valores a los par\[AAcute]metros \"a\" y \"b\".\
\>", "Text"],

Cell[BoxData[
    \(\(\(Do[
      Plot[y[1, b, t], {t, 0, 10}, 
        PlotRange \[Rule] {\(- .7\), 1.7}], {b, \(-2\), 2, 1}]\)\( (*\ 
      as\[IAcute]\ vemos\ c\[OAcute]mo\ cambia\ la\ soluci\[OAcute]n\ en\ \
funci\[OAcute]n\ de\ "\<b\>"\ cuando\ a = 1\ *) \)\)\)], "Input"],

Cell["\<\
Pero en una ED tambi\[EAcute]n podemos considerar variables los coeficientes \
de la ecuaci\[OAcute]n. Esto es interesante porque, en la pr\[AAcute]ctica, \
estos coeficientes se conocen con aproximaci\[OAcute]n e interesa saber c\
\[OAcute]mo la soluci\[OAcute]n obtenida depende de ellos. Podemos considerar \
la situaci\[OAcute]n m\[AAcute]s general: coeficientes y condiciones \
iniciales arbitrarias. Aqu\[IAcute] tienes definida la soluci\[OAcute]n m\
\[AAcute]s general del problema de Cauchy para la EDL de orden 1 completa con \
coeficientes constantes (pero arbitrarios) y t\[EAcute]rmino independiente \
tambi\[EAcute]n arbitrario.\
\>", "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(solEDL1[a_, b_, c_, func_] :=  (*\ 
        es\ obligada\ la\ asignaci\[OAcute]n\ diferida\ para\ que\ \
Mathematica\ no\ calcule\ simb\[OAcute]licamente\ la\ soluci\[OAcute]n\ en\ t\
\[EAcute]rminos\ de\ la\ funci\[OAcute]n\ desconocida\ "\<func\>"\ lo\ que\ \
despu\[EAcute]s\ puede\ dar\ problemas\ al\ particularizar\ funciones\ \
concretas . \ 
            Observa\ que\ la\ variable\ t\ no\ figura\ a\ la\ izquierda\ *) \ 
      y[t] /. \(DSolve[{\(y'\)[t] + \ c\ y[t] \[Equal] func[t], 
              y[a] \[Equal] b}, y, t]\)[\([1]\)]\)}], "Input"],

Cell["\<\
Todo lo que hay que hacer ahora es elegir una funci\[OAcute]n para \
sustituirla por \"func\".\
\>", "Text"],

Cell[BoxData[{
    \(\(f[t_] = t*Sin[t];\)\), "\[IndentingNewLine]", 
    \(h[a_, b_, c_, t_] = solEDL1[a, b, c, f]\), "\[IndentingNewLine]", 
    \( (*\ 
      esta\ es\ la\ soluci\[OAcute]n\ de\ la\ ED\ \[IndentingNewLine]\(y'\)[
                t] + c*y[t] == t*Sin[t]\ que\ verifica\ y[a] = 
        b . \ \[IndentingNewLine]Observa\ que\ ahora\ la\ variable\ t\ figura\
\ a\ la\ izquierda\ \ *) \)}], "Input"],

Cell["\<\
Si queremos soluciones particulares de esta ED podemos obtenerlas \
f\[AAcute]cilmente.\
\>", "Text"],

Cell[BoxData[
    \(h[0, 1, 3, t]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + c\ \(y'\)[t] + d\ y[t] = 0\)]],
  ", con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a, \(y'\)[0] = b\)]]
}], "Subsection"],

Cell[TextData[{
  "Esta ED es un modelo para oscilaciones libres con amortiguamiento. Vamos a \
realizar un programa que proporcione las soluciones de esta ED dependiendo de \
la naturaleza de las ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica. A veces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " presenta las soluciones de forma poco apropiada y hay que darle una \
ayudita para que las escriba como nosotros queremos. "
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Forma general de la soluci\[OAcute]n sin considerar la naturaleza de las ra\
\[IAcute]ces caracter\[IAcute]sticas\
\>", "Subsubsection"],

Cell[TextData[{
  "Empezamos calculando la soluci\[OAcute]n general de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  ". Sabemos que la soluci\[OAcute]n debe ser de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_1\) \[ExponentialE]\^\(\(a\_1\) t\) + \(C\_2\) \
\[ExponentialE]\^\(\(a\_2\) t\)\ donde\ C\_1\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(C\_2\)\(\ \)\)\)]],
  " son constantes que dependen de las condiciones iniciales (\
\[DownExclamation]y de los coeficientes de la ED!) y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Alpha]\_1\)\(\ \)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\_2\)]],
  " son las ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\[IAcute]stica ",
  Cell[BoxData[
      \(TraditionalForm\`z\^2 + c\ z + \ d\  = 0\)]],
  ". Dichas ra\[IAcute]ces son ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(-c\)\  \[PlusMinus] \ \@\(c\^2 - 4  \
d\)\)\/2\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(sol[t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + d\ y[t] \[Equal] 0, 
              y[0] \[Equal] a, \(y'\)[0] \[Equal] b}, y, 
            t]\)[\([1]\)]\)}], "Input"],

Cell["Vamos a agrupar las exponenciales y simplificamos.", "Text"],

Cell[BoxData[
    \(solgeneral[a_, b_, c_, d_, t_] = 
      Collect[%, \[ExponentialE]^\((x_)\), Simplify]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Forma de la soluci\[OAcute]n cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - 4\ d < 0\)]],
  " (ra\[IAcute]ces complejas)"
}], "Subsubsection"],

Cell[TextData[{
  "Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - \ 4\ d < 0\)]],
  ", se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(c\^2 - 4  d\) = I \@\( 4  d - c\^2\)\)]],
  ", las ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\[IAcute]stica son \
complejas e interesa obtener la soluci\[OAcute]n anterior expresada por medio \
de las funciones trigonom\[EAcute]tricas seno y coseno. Para ello vamos a \
usar ComplexExpand[ ] que expresa las exponenciales complejas en su forma \
trigonom\[EAcute]trica. Antes debemos quitar las ra\[IAcute]ces cuadradas  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sqrt]\((c\^2 - 4\ d)\)\)]],
  " para evitar que este comando las desarrolle. Para ello podemos usar la \
regla ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            \(TraditionalForm\`\(\(\ \)\(\(\@\(c\^2 - 4\ d\)\)^\((1/
                    2)\) \[Rule] I\ w\)\)\)]]]], TraditionalForm]]],
  " que se aplica a las ra\[IAcute]ces del numerador y la regla ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(\@\(c\^2 - 4\ d\)\)^\((\(-1\)/
              2)\) \[Rule] \(-I\)\ w^\((\(-1\))\)\)\)\)]],
  " que se aplica a la ra\[IAcute]z del denominador. Naturalmente, nosotros \
sabemos que ",
  Cell[BoxData[
      \(TraditionalForm\`w = \@\(4  d - c\^2\)\)]],
  "y despu\[EAcute]s de simplificar haremos la sustituci\[OAcute]n \
apropiada."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[
      solgeneral[a, b, c, d, 
          t] /. {\((c\^2 - 4\ d)\)^\((1/2)\) \[Rule] 
            I*w, \((c\^2 - 4\ d)\)^\((\(-1\)/2)\) \[Rule] \(-I\)*
              w^\((\(-1\))\)}]\)], "Input"],

Cell["\<\
Seguidamente agrupamos los t\[EAcute]rminos en Sin[ ] y simplificamos.\
\>", "Text"],

Cell[BoxData[
    \(Collect[%, Sin[x_], Simplify]\)], "Input"],

Cell[TextData[{
  "Finalmente, con la regla ",
  Cell[BoxData[
      \(TraditionalForm\`w\  \[Rule] \[Sqrt]\((\(-c\^2\) + 4\ d)\)\)]],
  " restituimos el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(tmp = % /. w -> \@\(4\ d - c\^2\)\)], "Input"],

Cell["\<\
Esta expresi\[OAcute]n ya es mejor. Observa que es de la forma \[Lambda] Cos[\
\[Omega]] + \[Mu] Sin[\[Omega]]. Es conveniente escribir estas soluciones de \
otra forma. \
\>", "Text"],

Cell[BoxData[{
    \(\(\(ComplexExpand[
      Im[\((\[Mu] + \ I\ \[Lambda])\) \((Cos[\[Omega]*t] + \ 
              I\ Sin[\[Omega]*t])\)]]\)\(\[IndentingNewLine]\)
    \) (*\ hacemos\ el\ mismo\ c\[AAcute]lculo\ pero\ expresamos\ \[Mu] + 
        I\[Lambda]\ en\ forma\ polar\ *) \), "\[IndentingNewLine]", 
    \(ComplexExpand[
        Im[\(\@\(\[Lambda]\^2 + \[Mu]\^2\)\) 
            Exp[I\ Arg[\[Mu] + \ I\ \[Lambda]]]*Exp[I\ \[Omega]*t]]] // 
      TrigReduce\)}], "Input"],

Cell[TextData[{
  "Hemos probado as\[IAcute] que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\ Cos[\[Omega]\ t] + \[Mu]\ Sin[\[Omega]\ \
t] = \@\(\[Lambda]\^2 + \[Mu]\^2\)\ Sin[
            t\ \[Omega] + Arg[\[ImaginaryI]\ \[Lambda] + \[Mu]]]\)]],
  ". Podemos definir un comando que pase a \"forma senoidal\" una funci\
\[OAcute]n de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(\[Lambda]\ Cos[t\ \[Omega]] + \[Mu]\ Sin[t\ \[Omega]]\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Incluyo unas reglas de sustituci\[OAcute]n para que las exponenciales se \
saquen fuera de las ra\[IAcute]ces cuadradas, y uso ComplexExpand[ ] para \
simplificar los argumentos aunque esto presupone que todos ellos son n\
\[UAcute]meros reales por lo que este comando debe usarse con cuidado. "
}], "Text"],

Cell[BoxData[
    \(formasenoidal[\[Lambda]_*Cos[\[Omega]_] + \[Mu]_*
            Sin[\[Omega]_]] := \[IndentingNewLine]\((\@Simplify[\[Lambda]\^2 \
+ \[Mu]\^2]*
            Sin[\[Omega] + 
                ComplexExpand[
                  Arg[Simplify[\[Mu] + \ 
                        I\ \[Lambda]]]]])\) /. {\((x___*\[ExponentialE]^y_*
                  z___)\)^\((1/
                  2)\) \[RuleDelayed] \((x*z)\)^\((1/
                    2)\)\ \[ExponentialE]^\((y/2)\), \((\[ExponentialE]^
                  u_)\)^\((1/2)\) \[RuleDelayed] \ \[ExponentialE]^\((u/
                  2)\)}\)], "Input"],

Cell["Expresemos en forma senoidal la soluci\[OAcute]n antes obtenida.", \
"Text"],

Cell[BoxData[
    \(formasenoidal[tmp]\)], "Input"],

Cell["Podemos definir esta soluci\[OAcute]n en la forma siguiente.", "Text"],

Cell[BoxData[
    \(\(solraicesimag[a_, b_, c_, d_, t_] = 
        2\ \@\(-\(\(b\^2 + a\ b\ c + a\^2\ d\)\/\(c\^2 - 4\ d\)\)\)\ \
\[ExponentialE]\^\(-\(\(c\ t\)\/2\)\)\ Sin[
            1\/2\ \@\(\(-c\^2\) + 4\ d\)\ t + 
              Arg[\[ImaginaryI]\ a + \(2\ b + a\ c\)\/\@\(\(-c\^2\) + 4\ \
d\)]];\)\)], "Input"],

Cell[TextData[{
  "Hagamos ",
  Cell[BoxData[
      \(TraditionalForm\`c = 0\)]],
  " para eliminar el amortiguamiento. Obtenemos as\[IAcute] la \
soluci\[OAcute]n general de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + d\ \(y(t)\) = 0\)]],
  ", que corresponde a oscilaciones libres sin amortiguamiento, con \
condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = a, \ y' \((0)\) = b\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(solraicesimag[a, b, 0, d, t]\)], "Input"],

Cell[TextData[{
  "Se trata de un movimiento arm\[OAcute]nico simple con amplitud ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(\(b\^2 + a\^2\ d\)\/d\)\)]],
  ", frecuencia angular ",
  Cell[BoxData[
      \(TraditionalForm\`\@d\)]],
  "(radianes por segundo), periodo ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]/\@d\)]],
  "y fase inicial ",
  Cell[BoxData[
      \(TraditionalForm\`Arg[\[ImaginaryI]\ a + b\/\@d]\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Forma de la soluci\[OAcute]n cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - 4\ d = 0\)]],
  " (una ra\[IAcute]z real doble)"
}], "Subsubsection"],

Cell["\<\
Este caso corresponde a una ra\[IAcute]z real doble de la ecuaci\[OAcute]n \
caracter\[IAcute]stica y es muy sencillo.\
\>", "Text"],

Cell[BoxData[
    \(solraizdoble[a_, b_, c_, t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + c\^2\/4\ y[t] \[Equal] 0, 
              y[0] \[Equal] a, \(y'\)[0] \[Equal] b}, y, 
            t]\)[\([1]\)]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Forma general de la soluci\[OAcute]n considerando la naturaleza de las ra\
\[IAcute]ces caracter\[IAcute]sticas\
\>", "Subsubsection"],

Cell[TextData[{
  "Podemos reunir los resultados obtenidos en una funci\[OAcute]n que en cada \
caso proporcione la soluci\[OAcute]n en la forma adecuada. Observa la forma \
en que escribo las condiciones usando un triple = para que ",
  StyleBox["siempre",
    FontSlant->"Italic"],
  " se eval\[UAcute]en."
}], "Text"],

Cell[BoxData[
    \(solucion[a_, b_, c_, d_, t_] := 
      If[Negative[c\^2 - 4  d] === True\ , \  (*\ 
          ra\[IAcute]ces\ imaginarias\ *) \ solraicesimag[a, b, c, d, t], 
        If[c\^2 - 4  d === 0,  (*\ ra\[IAcute]z\ real\ doble\ *) \ 
          solraizdoble[a, b, c, t],  (*\ 
            ra\[IAcute]ces\ reales\ distintas\ *) \ 
          solgeneral[a, b, c, d, t]]]\)], "Input"],

Cell["Comprobemos este comando en los varios casos posibles.", "Text"],

Cell[BoxData[
    \(\(\(solucion[2, \(-3\)/2, 2, 3, t]\)\( (*\ 
      se\ cumplen\ que\ c\^2 - 4  d < 
        0. \[IndentingNewLine]Soluci\[OAcute]n\ correspondiente\ a\ ra\
\[IAcute]ces\ complejas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(solucion[1, \(-3\)/2, 1, 15/4, t]\)\( (*\ 
      se\ cumplen\ que\ c\^2 - 4  d < 
        0. \[IndentingNewLine]Soluci\[OAcute]n\ correspondiente\ a\ ra\
\[IAcute]ces\ complejas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(solucion[1, \(-1\), 2, 2, t]\)\(\ \)\( (*\ 
      se\ cumplen\ que\ c\^2 - 4  d < 
        0. \[IndentingNewLine]Soluci\[OAcute]n\ correspondiente\ a\ ra\
\[IAcute]ces\ complejas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(solucion[1, 3, 2, 1, t]\)\(\ \)\( (*\ 
      en\ este\ caso\ c\^2 - 4  d = 
        0. \ Una\ ra\[IAcute]z\ real\ doble\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(solucion[1, 3, 3, 1, t]\)\( (*\ 
      en\ este\ caso\ c\^2 - 4  d > 
        0. \ Dos\ ra\[IAcute]ces\ reales\ distintas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(solucion[1, 1, c, 2, t]\)\( (*\ 
      soluci\[OAcute]n\ general\ dependiendo\ del\ par\[AAcute]metro\ c\ *) \
\)\)\)], "Input"],

Cell["Parece que funciona correctamente.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Las soluciones de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + c\ \(y'\)[t] + \ 
          d\ y[t] = \[Lambda]\ Cos[\[Omega]\ t]\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - 4  d < 0\)]]
}], "Subsubsection"],

Cell[TextData[{
  "En este caso, se trata de oscilaciones forzadas. La fuerza externa \
aplicada es ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = \[Lambda]\ \(cos(\[Omega]\ t)\)\)]],
  ". Calculemos la soluci\[OAcute]n general."
}], "Text"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ 
                d\ y[t] \[Equal] \[Lambda]\ Cos[\[Omega]\ t]}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell["Agrupemos t\[EAcute]rminos.", "Text"],

Cell[BoxData[
    \(Collect[%, {C[1], C[2], Cos[x_], Sin[x_]}, Simplify]\)], "Input"],

Cell[TextData[{
  "Observa que es de la forma \"soluci\[OAcute]n general de la ED homog\
\[EAcute]nea + soluci\[OAcute]n particular de la ED completa\". Suponiendo \
que ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - 4  d < 0\)]],
  ", pasemos a forma senoidal las dos partes de la soluci\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(\(formasenoidal[
        Collect[\((ComplexExpand[\[ExponentialE]\^\(\(-\(1\/2\)\)\ \((c + \
\@\(c\^2 - 4\ d\))\)\ t\)\ C[
                        1] + \[ExponentialE]\^\(1\/2\ \((\(-c\) + \@\(c\^2 - \
4\ d\))\)\ t\)\ C[2] /. \((c\^2 - 4  d\ )\)^\((1/2)\) \[Rule] I*w])\), {Cos[
                x_], Sin[x_]}, Simplify] /. 
          w \[Rule] \@\(4  d - c\^2\)];\)\), "\[IndentingNewLine]", 
    \(\(formasenoidal[\(\[Lambda]\ \((d - \[Omega]\^2)\)\ Cos[t\ \
\[Omega]]\)\/\(d\^2 + c\^2\ \[Omega]\^2 - 2\ d\ \[Omega]\^2 + \[Omega]\^4\) + \
\(c\ \[Lambda]\ \[Omega]\ Sin[t\ \[Omega]]\)\/\(d\^2 + c\^2\ \[Omega]\^2 - 2\ \
d\ \[Omega]\^2 + \[Omega]\^4\)];\)\), "\[IndentingNewLine]", 
    \(FullSimplify[%% + %, \[Lambda] > 0]\)}], "Input"],

Cell[TextData[{
  "Vemos que el movimiento est\[AAcute] formado por la superposici\[OAcute]n \
de un movimiento oscilatorio amortiguado que pr\[AAcute]cticamente cesa al \
cabo de un tiempo, pues para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " suficientemente grande, ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\(-\(\(c\ t\)\/2\)\)\)]],
  "es muy peque\[NTilde]o, y de un movimiento movimiento arm\[OAcute]nico \
simple que permanece a lo largo del tiempo. El sistema acaba oscilando con la \
misma frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\)]],
  " que la fuerza exterior aplicada. Adem\[AAcute]s la amplitud del \
movimiento depende de dicha frecuencia. Para valores grandes de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " dicha amplitud es aproximadamente igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\ \@\(1\/\(c\^2\ \[Omega]\^2 + \((d - \
\[Omega]\^2)\)\^2\)\)\)]],
  "y, cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " es muy peque\[NTilde]o, la amplitud se hace muy grande cuando ",
  Cell[BoxData[
      \(TraditionalForm\`d = \[Omega]\^2\)]],
  ", es decir cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = \@d\)]],
  ", lo que ocurre cuando la frecuencia de la fuerza exterior aplicada es \
igual a la frecuencia del sistema cuando oscila libremente sin \
amortiguamiento. Esto es lo que se conoce como ",
  StyleBox["resonancia",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "El comando",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["NDSolve[", "MR",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox[" ", "TI",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox["]", "MR",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontFamily->"Times New Roman"]
}], "Subsubsection"],

Cell[TextData[{
  "Este comando es quiz\[AAcute]s el m\[AAcute]s importante de los comandos \
num\[EAcute]ricos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y puede resolver de forma num\[EAcute]rica una gran cantidad de EDOs. Su \
sintaxis es"
}], "Text"],

Cell["\<\
NDSolve[listadeEDOsyCondicionesIniciales, listadeFunciones, \
VariableIndependienteyIntervalo, Opciones]\
\>", "Text",
  TextAlignment->Center],

Cell[TextData[{
  "e intenta resolver num\[EAcute]ricamente las EDO(s) con condiciones \
iniciales dadas, que es preciso especificar siempre, en ",
  StyleBox["listadeEDOsyCondicionesIniciales",
    FontSlant->"Italic"],
  " para las funciones en ",
  StyleBox["listadeFunciones",
    FontSlant->"Italic"],
  ". La variable independiente es ",
  StyleBox["VariableIndependiente",
    FontSlant->"Italic"],
  ".  Cuando este comando tiene \[EAcute]xito, su salida es una lista de \
funciones que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa como InterpolatingFunction[ ]",
  "."
}], "Text"],

Cell[TextData[{
  "El resultado de algunos comandos de ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "como NDSolve[ ] o Interpolation[listadeDatos], entre otros, se muestra \
como \"InterpolatingFunction[intervalo,listadeDatos]\" que representa una \
funci\[OAcute]n que interpola los datos dados en el intervalo especificado. \
Veamos un ejemplo."
}], "Text"],

Cell[BoxData[
    \(coseno = 
      Interpolation[Table[{x, Cos[x]}, {x, \(-4. \), 4. ,  .25}]]\)], "Input"],

Cell[TextData[{
  "Si quieres ver los detalles de esta funci\[OAcute]n (ocultos en el s\
\[IAcute]mbolo ",
  Cell[BoxData[
      FormBox[Cell["< >"], TraditionalForm]]],
  ") puedes hacerlo como sigue."
}], "Text"],

Cell[BoxData[
    \(InputForm[coseno]\)], "Input"],

Cell[TextData[{
  "Puedes evaluar, derivar y representar esta funci\[OAcute]n de la forma \
usual. Sin olvidar que la funci\[OAcute]n est\[AAcute] definida solamente en \
el intervalo [-4,4]. Si pides un valor de la funci\[OAcute]n fuera de este \
intervalo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " muestra un mensaje de error e intenta hacer una extrapolaci\[OAcute]n \
para calcularlo de forma aproximada."
}], "Text"],

Cell[BoxData[
    \(\(\(coseno[Pi/2]\)\( (*\ casi\ 0\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(coseno[4.5]\)\( (*\ 
      un\ valor\ fuera\ del\ intervalo\ [0, 7]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(coseno'\)[Pi/2]\)\(\ \)\( (*\ casi\  - 1\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[{coseno[x], \(coseno'\)[x]}, {x, \(-Pi\), Pi}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .65]}];\)\)], "Input"],

Cell["Veamos c\[OAcute]mo trabaja NDSolve[ ].", "Text"],

Cell[BoxData[
    \(sol = 
      NDSolve[{\(x''\)[t] \[Equal] \(-x[t]\), 
          x[0] \[Equal] 1, \(x'\)[0] \[Equal] 0} (*\ 
          es\ obligado\ dar\ suficientes\ condiciones\ iniciales\ para\ \
obtener\ una\ \[UAcute]nica\ soluci\[OAcute]n\ de\ la\ ED\ *) , 
        x, {t, {\(-4\), 4}}\  (*\ 
          es\ obligado\ dar\ un\ intervalo\ donde\ se\ va\ a\ calcular\ la\ \
soluci\[OAcute]n\ aproximada\ *) ]\)], "Input"],

Cell["\<\
Para trabajar con esta funci\[OAcute]n conviene representarla de forma m\
\[AAcute]s manejable.\
\>", "Text"],

Cell[BoxData[
    \(x = x /. sol[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(\(\(Plot[{x[t], \(x'\)[t]}, {t, \(-Pi\), Pi}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .65]}];\)\[IndentingNewLine]
    \(Plot[{coseno[t], x[t]}, {t, \(-Pi\), Pi}];\)\)\( (*\ 
      sobre\ la\ gr\[AAcute]fica\ no\ se\ distinguen\ las\ funciones\ coseno[
          t]\ y\ x[t]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(y = 
      y /. \(NDSolve[{\(y'''''\)[t] - 5 \( y''\)[t] + 4 \( y'\)[t] - 
                  2  y[t] \[Equal] 0, 
              y[0] \[Equal]  .5, \(y'\)[0] \[Equal] 
                1, \(y''\)[0] \[Equal] \(-2\), \(y'''\)[
                  0] \[Equal] \(-3\), \(y''''\)[0] \[Equal] 4}, 
            y, {t, \(-1\), 1}]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(Plot[y[t], {t, \(-1\), 1}];\)\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell[BoxData[
    \(y[t_] = 
      y[t] /. \(NDSolve[{\(y'\)[t] \[Equal] 3.5  Sin[y[t]] -  .5  t^2, 
              y[0] \[Equal]  .5}, y, {t, \(-3\), 3}]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(Plot[y[t], {t, \(-3\), 3}];\)\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell["Naturalmente, podemos usar NDSolve[ ] para sistemas de EDs.", "Text"],

Cell[BoxData[
    \(NDSolve[{\(x'\)[t] \[Equal] \(-y[t]\) - x[t]^2, \(y'\)[t] \[Equal] 
          2  x[t] - y[t], x[0] \[Equal] 1, y[0] \[Equal] 1}, {x, y}, {t, 0, 
        10}]\)], "Input"],

Cell["\<\
Podemos expresar las soluciones obtenidas de forma m\[AAcute]s \
c\[OAcute]moda.\
\>", "Text"],

Cell[BoxData[
    \({x[t_], 
        y[t_]} = \(\({x[t], y[t]}\)\(/.\)\(%[\([1]\)]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[{x[t], y[t]}, {t, 0, 10}, PlotStyle \[Rule] {Hue[0], Hue[ .65]}, 
        AspectRatio \[Rule] 1/GoldenRatio];\)\)], "Input"],

Cell[BoxData[{
    \(\(Clear["\<@\>"];\)\), "\n", 
    \(\(aproxsols = 
        NDSolve[{\(y'\)[t] \[Equal] 
              0.7\ y[t] - 0.3\ y[t]\ x[t], \(x'\)[t] == \(-0.44\)\ x[t] + 
                0.08\ x[t]\ y[t], y[0] \[Equal] 4, x[0] \[Equal] 1.2}, {x, 
            y}, {t, 0, 50}];\)\), "\n", 
    \(\({x[t_], y[t_]} = {x[t], y[t]} /. aproxsols[\([1]\)];\)\n (*\ 
      este\ es\ un\ modelo\ poblacional "\<depredador(y)-presa(x)\>"\ *) \), \
"\n", 
    \(\(Plot[{x[t], y[t]}, {t, 0, 50}, 
        PlotStyle \[Rule] {{Hue[ .65], Thickness[0.01]}, {Hue[0], 
              Thickness[0.01]}}, 
        AspectRatio \[Rule] 1/GoldenRatio];\)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Laplace", "Section"],

Cell["El comando ", "Text"],

Cell["LaplaceTransform[funci\[OAcute]n[variable1],variable1,variable2]", \
"Text",
  TextAlignment->Center],

Cell["\<\
calcula la transformada de Laplace de \"funci\[OAcute]n\" y la expresa como \
una funci\[OAcute]n de \"variable2\".  Este comando no indica el campo de \
convergencia de la transformada de Laplace.\
\>", "Text"],

Cell[BoxData[{
    \(LaplaceTransform[\(t\^2\) Exp[a*t], t, s]\), "\[IndentingNewLine]", 
    \(LaplaceTransform[t*Sin[a*t], t, s]\)}], "Input"],

Cell[TextData[{
  "A partir de la versi\[OAcute]n 4 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " podemos especificar condiciones (con \"Assumptions\") para ayudar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en los c\[AAcute]lculos."
}], "Text"],

Cell[BoxData[
    \(LaplaceTransform[t*Sin[a*t], t, s, 
      Assumptions \[Rule] a > 0]\)], "Input"],

Cell["\<\
Para saber el campo de convergencia debemos hacer el c\[AAcute]lculo \
directamente.\
\>", "Text"],

Cell[BoxData[
    \(\[Integral]\_0\%\[Infinity]\( t\^3\) 
        Exp[a*t]*\(\[ExponentialE]\^\(\(-s\)*
              t\)\) \[DifferentialD]t\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nos dice que el dominio de convergencia de la integral es el semiplano ",
  Cell[BoxData[
      \(TraditionalForm\`Re[s] > Re[a]\)]],
  ". En las aplicaciones de la transformada de Laplace a la \
resoluci\[OAcute]n de EDs no hay que preocuparse por el dominio de \
convergencia."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce las propiedades de la transformada de Laplace."
}], "Text"],

Cell[BoxData[
    \(\(\(LaplaceTransform[c*a[t] + d*b[t], t, s] (*\ linealidad\ *) \n
    LaplaceTransform[Integrate[h[u], {u, 0, t}], t, s] (*\ 
      transformada\ de\ una\ integral\ *) \[IndentingNewLine]
    LaplaceTransform[\(f'\)[t], t, s] (*\ 
      transformada\ de\ una\ derivada\ primera\ *) \[IndentingNewLine]
    LaplaceTransform[\(f''\)[t], t, s] (*\ 
      transformada\ de\ una\ derivada\ segunda\ *) \[IndentingNewLine]
    D[LaplaceTransform[f[t], t, s], s] (*\ 
      derivada\ primera\ de\ una\ transformada\ *) \[IndentingNewLine]
    D[LaplaceTransform[f[t], t, s], {s, 2}]\)\( (*\ 
      derivada\ segunda\ de\ una\ transformada\ *) \)\)\)], "Input"],

Cell["\<\
La transformada inversa se calcula con el comando InverseLaplaceTransform[ ].\
\
\>", "Text"],

Cell[BoxData[
    \(InverseLaplaceTransform[s\^2\/\(s\^4 + 1\), s, t]\)], "Input"],

Cell["Podemos comprobar este resultado.", "Text"],

Cell[BoxData[
    \(LaplaceTransform[%, t, s] // Simplify\)], "Input"],

Cell["Podemos simplificar bastante el resultado obtenido.", "Text"],

Cell[BoxData[
    \(\(%% // FullSimplify\) // ComplexExpand\)], "Input"],

Cell["Podemos usar la transformada de Laplace para resolver EDLs.", "Text"],

Cell[BoxData[{
    \(\(\(Clear["\<@\>"]\)\(\[IndentingNewLine]\)\( (*\ 
      para\ resolver\ la\ EDL\ \(y''\)[t] + \(y'\)[t] + y[t] \[Equal] 
          Cos[t]\ \[IndentingNewLine]con\ condiciones\ iniciales\ y[
              0] = \(\(y'\)[0] = 0\)\ *) \)\(\[IndentingNewLine]\)
    \) (*\ calculamos\ la\ transformadade\ Laplace\ de\ y[
          t]\ sustituyendo\ las\ condiciones\ iniciales\ *) \), "\
\[IndentingNewLine]", 
    \(\(\(Solve[\((LaplaceTransform[\(y''\)[t] + \(y'\)[t] + y[t] - Cos[t], 
              t, s] /. {y[0] \[Rule] 0, \(y'\)[0] \[Rule] 0})\) \[Equal] 0, 
      LaplaceTransform[y[t], t, s]]\)\(\[IndentingNewLine]\)
    \) (*\ 
      extraemos\ la\ soluci\[OAcute]n\ obtenida\ *) \), \
"\[IndentingNewLine]", 
    \(\(\(LaplaceTransform[y[t], t, s] /. %[\([1]\)]\)\(\[IndentingNewLine]\)
    \) (*\ 
      calculamos\ la\ transformada\ inversa\ *) \), "\[IndentingNewLine]", 
    \(\(\(y[t_] = InverseLaplaceTransform[%, s, t]\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ la\ soluci\[OAcute]n\ obtenida\ *) \), \
"\[IndentingNewLine]", 
    \({\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] Cos[t], 
        y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0} // Simplify\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de funciones anal\[IAcute]ticas de una matriz \
cuadrada", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando, MatrixExp[matriz], que calcula la exponencial de \
una matriz."
}], "Text"],

Cell["\<\
A = {{2,-1,2,0}, {0,3,-1,0}, {0,1,1,0}, {0,1,-3,5}}; 
MatrixExp[A*t]//MatrixForm\
\>", "Input",
  AspectRatioFixed->True,
  FontFamily->"Courier New",
  FontVariations->{"CompatibilityType"->0}],

Cell[TextData[{
  "Que yo sepa no hay comandos que permitan calcular directamente otras \
funciones anal\[IAcute]ticas de una matriz. Supongamos que queremos calcular \
",
  Cell[BoxData[
      \(TraditionalForm\`f(A\ t)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\ es\ una\ funci\[OAcute]n\ anal\[IAcute]tica\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es la matriz anterior. El procedimiento que se sigue para ello es el \
siguiente.  \n1) Se calculan los valores propios de la matriz."
}], "Text"],

Cell[BoxData[
    \(Eigenvalues[A]\)], "Input"],

Cell[TextData[{
  "Hay un valor propio simple ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 5\)]],
  " y un valor propio triple ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Lambda]", "=", "2.", 
          StyleBox[" ",
            FontSlant->"Italic"]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "2) Se calcula el polinomio interpolador cuyo valor en ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 5\)]],
  " coincide con ",
  Cell[BoxData[
      \(TraditionalForm\`f(5\ t)\)]],
  " y cuyo valor y el de sus dos primeras derivadas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 2\)]],
  " coincide con el calor de ",
  Cell[BoxData[
      \(TraditionalForm\`f(z\ t)\)]],
  " y el de sus dos primeras derivadas respecto a ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`z = 2\)]],
  ". Para ello ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando"
}], "Text"],

Cell[TextData[{
  "InterpolatingPolynomial[{",
  Cell[BoxData[
      \(TraditionalForm\`\(\({x\_1, \ {f\_1, \ df\_1, \ 
          ddf\_1,  ... }}\)\(\ \)\)\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`{x\_2, {f\_2, \ df\_2, ddf\_2\ ,  ... }}\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`{x\_3, {f\_3, \ df\_3, ddf\_3\ ,  ... }}\)]],
  "... }, var]"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que calcula un polinomio en la variable \"var\" cuyo valor en ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`f\_j\)]],
  ", el valor de su primera derivada en ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`df\_j\)]],
  ", el valor de su segunda derivada en ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`ddf\_j\ , \ \(\(etc\[EAcute]tera\)\(.\)\(\ \)\)\)]],
  "Cuando solamente se especifica el valor ",
  Cell[BoxData[
      \(TraditionalForm\`f\_j\)]],
  " la correspondiente lista debe ser de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_j, \ f\_j}\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ 
      En\ nuestro\ caso\ ser\[IAcute]a\ InterpolatingPolynomial[{{5, 
              f[5\ t]}, {2, {f[2\ t], \ D[f[z\ t], z] /. z \[Rule] 2, \ 
                D[f[z\ t], {z, 2}] /. z \[Rule] 2}}}, 
          w]\ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Supongamos\ que\ queremos\ calcular\ f[A\ t]\ donde\ f[
            z] = \(Exp[z\^2] - 1\)\/z\^2, \ 
      f[0] = 1. \ Esta\ funci\[OAcute]n\ es\ anal\[IAcute]tica\ y\ su\ serie\ \
de\ potencias\ converge\ en\ todo\ el\ plano\ complejo\ *) \)\(\
\[IndentingNewLine]\)\(\(f[
          z_] = \(Exp[z\^2] - 1\)\/z\^2;\)\[IndentingNewLine]
    \(InterpolatingPolynomial[{{5, 
            f[5\ t]}, {2, {f[2\ t], \ D[f[z\ t], z] /. z \[Rule] 2, \ 
              D[f[z\ t], {z, 2}] /. z \[Rule] 2}}}, w];\)\[IndentingNewLine]
    p[w_] = Collect[%, w, Simplify]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\({p[5], p[2], \(p'\)[2], \(p''\)[2]} - {f[5\ t], f[2\ t], \ 
          D[f[z\ t], z] /. z \[Rule] 2, \ 
          D[f[z\ t], {z, 2}] /. z \[Rule] 2}\)\(//\)\(Simplify\)\(\ \)\( (*\ 
        comprobamos\ la\ soluci\[OAcute]n\ obtenida\ *) \)\)\)], "Input"],

Cell[TextData[{
  "3) Se eval\[UAcute]a el polinomio interpolador en la matriz ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". Ten en cuenta que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " considera ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " como una lista, por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`A\^2\)]],
  " no es el producto matricial de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " sino el cuadrado de los elementos de la lista ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(A\^2\)], "Input"],

Cell[TextData[{
  "Por eso, para calcular",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(p\) \((A)\)\(\ \)\)\)\)]],
  " hay que hacerlo de forma apropiada. Para ello extraemos los coeficientes \
del polinomio y los multiplicamos por las respectivas potencias de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " y sumamos."
}], "Text"],

Cell[BoxData[
    \(f[A\ t_] = 
      CoefficientList[p[w], w] . 
          Table[MatrixPower[A, k\  - \ 1], \n\t\t{k, 1, 4}] // 
        Simplify\)], "Input"],

Cell[TextData[{
  "En este caso concreto, podemos calcular de forma m\[AAcute]s sencilla ",
  Cell[BoxData[
      \(TraditionalForm\`f[A\ t]\)]],
  " usando el comando MatrixExp[ ]. Teniendo en cuenta c\[OAcute]mo est\
\[AAcute] definida la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " y que las operaciones en la variable ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " se corresponden con operaciones (productos y sumas) en la matriz ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", podemos proceder como sigue."
}], "Text"],

Cell[BoxData[
    \(\((MatrixExp[A . A\ t\^2] - IdentityMatrix[4])\) . Inverse[A\ t] . 
        Inverse[A\ t] // Simplify\)], "Input"],

Cell[TextData[{
  "Vamos a hacer este c\[AAcute]lculo por medio de transformadas de Laplace. \
Todo lo que debemos calcular es la exponencial de la matriz ",
  Cell[BoxData[
      \(TraditionalForm\`A . A\ t\^2\)]],
  ". Sabemos que, dada una matriz ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ", la exponencial ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\(M\ t\)\)]],
  " viene dada por la transformada de Laplace inversa de la matriz ",
  Cell[BoxData[
      \(TraditionalForm\`\((s\ I - M)\)\^\(-1\)\)]],
  ", donde el c\[AAcute]culo de dicha transformada se hace elemento a \
elemento."
}], "Text"],

Cell[BoxData[{
    \(\(B = 
        Inverse[s*IdentityMatrix[4] - A . A] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(\(U[t_] = 
        Table[InverseLaplaceTransform[B[\([j, k]\)] // Simplify, s, t] // 
            Simplify, {j, 1, 4}, {k, 1, 4}] (*\ 
        U[t]\ es\ la\ exponencial\ de\ la\ matriz\ A . At, \ 
        por\ lo\ que\ U[t\^2]\ \ es\ la\ exponencial\ de\ la\ matriz\ A . 
            At\^2\ *) ;\)\), "\[IndentingNewLine]", 
    \(\((U[t\^2] - IdentityMatrix[4])\) . Inverse[A\ t] . Inverse[A\ t] // 
      Simplify\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "GraphicsArray"->{
    Cell[9846, 256, 123, 3, 50, "Input",
      CellTags->"GraphicsArray"]},
  "S3.5.10"->{
    Cell[15586, 405, 200, 6, 93, "Input",
      CellTags->"S3.5.10"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"GraphicsArray", 53240, 1509},
  {"S3.5.10", 53331, 1512}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 161, 4, 169, "Title"],
Cell[1918, 57, 189, 7, 96, "Author"],

Cell[CellGroupData[{
Cell[2132, 68, 84, 1, 62, "Section"],

Cell[CellGroupData[{
Cell[2241, 73, 45, 0, 45, "Subsubsection"],
Cell[2289, 75, 229, 6, 29, "Text"],
Cell[2521, 83, 134, 4, 29, "Text"],
Cell[2658, 89, 1239, 28, 105, "Text"],
Cell[3900, 119, 942, 18, 130, "Input"],
Cell[4845, 139, 1191, 28, 86, "Text"],
Cell[6039, 169, 400, 7, 90, "Input"],
Cell[6442, 178, 84, 1, 29, "Text"],
Cell[6529, 181, 161, 2, 50, "Input"],
Cell[6693, 185, 377, 8, 48, "Text"],
Cell[7073, 195, 692, 10, 67, "Text"],
Cell[7768, 207, 683, 14, 90, "Input"],
Cell[8454, 223, 264, 7, 29, "Text"],
Cell[8721, 232, 1122, 22, 110, "Input"],
Cell[9846, 256, 123, 3, 50, "Input",
  CellTags->"GraphicsArray"],
Cell[9972, 261, 152, 4, 29, "Text"],
Cell[10127, 267, 240, 4, 70, "Input"],
Cell[10370, 273, 432, 9, 48, "Text"],
Cell[10805, 284, 566, 11, 71, "Input"],
Cell[11374, 297, 431, 8, 83, "Input"],
Cell[11808, 307, 89, 2, 27, "Text"],
Cell[11900, 311, 184, 3, 65, "Input"],
Cell[12087, 316, 595, 11, 87, "Text"],
Cell[12685, 329, 156, 2, 62, "Input"],
Cell[12844, 333, 512, 12, 62, "Text"],
Cell[13359, 347, 46, 1, 62, "Input"],
Cell[13408, 350, 398, 8, 62, "Text"],
Cell[13809, 360, 395, 7, 114, "Input"],
Cell[14207, 369, 430, 9, 62, "Text"],
Cell[14640, 380, 137, 2, 48, "Input"],
Cell[14780, 384, 666, 14, 79, "Text"],
Cell[15449, 400, 134, 3, 27, "Text"],
Cell[15586, 405, 200, 6, 93, "Input",
  CellTags->"S3.5.10"],
Cell[15789, 413, 225, 4, 44, "Text"],
Cell[16017, 419, 133, 3, 27, "Text"],
Cell[16153, 424, 431, 7, 100, "Input"],
Cell[16587, 433, 216, 4, 65, "Input"],
Cell[16806, 439, 324, 8, 44, "Text"],
Cell[17133, 449, 453, 8, 132, "Input"],
Cell[17589, 459, 174, 3, 27, "Text"],
Cell[17766, 464, 277, 5, 80, "Input"],
Cell[18046, 471, 666, 10, 96, "Text"],
Cell[18715, 483, 625, 10, 169, "Input"],
Cell[19343, 495, 118, 3, 27, "Text"],
Cell[19464, 500, 414, 7, 117, "Input"],
Cell[19881, 509, 111, 3, 27, "Text"],
Cell[19995, 514, 46, 1, 48, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20078, 520, 254, 7, 52, "Subsection"],
Cell[20335, 529, 464, 9, 62, "Text"],

Cell[CellGroupData[{
Cell[20824, 542, 146, 3, 44, "Subsubsection"],
Cell[20973, 547, 1003, 26, 72, "Text"],
Cell[21979, 575, 250, 5, 97, "Input"],
Cell[22232, 582, 66, 0, 27, "Text"],
Cell[22301, 584, 119, 2, 62, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22457, 591, 172, 5, 44, "Subsubsection"],
Cell[22632, 598, 1403, 30, 114, "Text"],
Cell[24038, 630, 228, 5, 80, "Input"],
Cell[24269, 637, 94, 2, 27, "Text"],
Cell[24366, 641, 62, 1, 62, "Input"],
Cell[24431, 644, 231, 8, 27, "Text"],
Cell[24665, 654, 66, 1, 70, "Input"],
Cell[24734, 657, 194, 4, 44, "Text"],
Cell[24931, 663, 479, 9, 106, "Input"],
Cell[25413, 674, 852, 17, 79, "Text"],
Cell[26268, 693, 607, 12, 132, "Input"],
Cell[26878, 707, 82, 1, 27, "Text"],
Cell[26963, 710, 51, 1, 62, "Input"],
Cell[27017, 713, 76, 0, 27, "Text"],
Cell[27096, 715, 317, 6, 118, "Input"],
Cell[27416, 723, 445, 13, 44, "Text"],
Cell[27864, 738, 61, 1, 62, "Input"],
Cell[27928, 741, 448, 14, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28413, 760, 175, 5, 44, "Subsubsection"],
Cell[28591, 767, 142, 3, 27, "Text"],
Cell[28736, 772, 227, 4, 100, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29000, 781, 144, 3, 44, "Subsubsection"],
Cell[29147, 786, 320, 7, 44, "Text"],
Cell[29470, 795, 392, 7, 132, "Input"],
Cell[29865, 804, 70, 0, 27, "Text"],
Cell[29938, 806, 220, 4, 80, "Input"],
Cell[30161, 812, 223, 4, 80, "Input"],
Cell[30387, 818, 224, 4, 80, "Input"],
Cell[30614, 824, 165, 3, 80, "Input"],
Cell[30782, 829, 167, 3, 80, "Input"],
Cell[30952, 834, 152, 3, 62, "Input"],
Cell[31107, 839, 50, 0, 27, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31194, 844, 266, 8, 44, "Subsubsection"],
Cell[31463, 854, 245, 6, 27, "Text"],
Cell[31711, 862, 172, 3, 62, "Input"],
Cell[31886, 867, 43, 0, 27, "Text"],
Cell[31932, 869, 85, 1, 62, "Input"],
Cell[32020, 872, 316, 7, 44, "Text"],
Cell[32339, 881, 758, 12, 256, "Input"],
Cell[33100, 895, 1488, 37, 154, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34625, 937, 408, 15, 45, "Subsubsection"],
Cell[35036, 954, 273, 7, 44, "Text"],
Cell[35312, 963, 153, 4, 27, "Text"],
Cell[35468, 969, 614, 17, 79, "Text"],
Cell[36085, 988, 372, 8, 62, "Text"],
Cell[36460, 998, 108, 2, 48, "Input"],
Cell[36571, 1002, 214, 6, 27, "Text"],
Cell[36788, 1010, 50, 1, 48, "Input"],
Cell[36841, 1013, 438, 9, 62, "Text"],
Cell[37282, 1024, 74, 1, 48, "Input"],
Cell[37359, 1027, 113, 2, 48, "Input"],
Cell[37475, 1031, 88, 1, 48, "Input"],
Cell[37566, 1034, 137, 2, 48, "Input"],
Cell[37706, 1038, 55, 0, 27, "Text"],
Cell[37764, 1040, 427, 8, 132, "Input"],
Cell[38194, 1050, 119, 3, 27, "Text"],
Cell[38316, 1055, 54, 1, 62, "Input"],
Cell[38373, 1058, 319, 5, 82, "Input"],
Cell[38695, 1065, 363, 7, 100, "Input"],
Cell[39061, 1074, 64, 1, 48, "Input"],
Cell[39128, 1077, 47, 1, 48, "Input"],
Cell[39178, 1080, 177, 3, 65, "Input"],
Cell[39358, 1085, 64, 1, 48, "Input"],
Cell[39425, 1088, 47, 1, 62, "Input"],
Cell[39475, 1091, 75, 0, 27, "Text"],
Cell[39553, 1093, 190, 3, 80, "Input"],
Cell[39746, 1098, 104, 3, 27, "Text"],
Cell[39853, 1103, 105, 2, 62, "Input"],
Cell[39961, 1107, 151, 2, 80, "Input"],
Cell[40115, 1111, 683, 14, 201, "Input"],
Cell[40801, 1127, 47, 1, 62, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40909, 1135, 42, 0, 62, "Section"],
Cell[40954, 1137, 27, 0, 27, "Text"],
Cell[40984, 1139, 107, 2, 27, "Text"],
Cell[41094, 1143, 221, 4, 44, "Text"],
Cell[41318, 1149, 144, 2, 66, "Input"],
Cell[41465, 1153, 278, 8, 44, "Text"],
Cell[41746, 1163, 101, 2, 48, "Input"],
Cell[41850, 1167, 108, 3, 27, "Text"],
Cell[41961, 1172, 154, 3, 61, "Input"],
Cell[42118, 1177, 363, 9, 44, "Text"],
Cell[42484, 1188, 138, 4, 27, "Text"],
Cell[42625, 1194, 673, 11, 169, "Input"],
Cell[43301, 1207, 103, 3, 27, "Text"],
Cell[43407, 1212, 82, 1, 80, "Input"],
Cell[43492, 1215, 49, 0, 27, "Text"],
Cell[43544, 1217, 70, 1, 62, "Input"],
Cell[43617, 1220, 67, 0, 27, "Text"],
Cell[43687, 1222, 72, 1, 62, "Input"],
Cell[43762, 1225, 75, 0, 27, "Text"],
Cell[43840, 1227, 1202, 22, 288, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45079, 1254, 91, 1, 62, "Section"],
Cell[45173, 1257, 170, 5, 27, "Text"],
Cell[45346, 1264, 204, 6, 77, "Input"],
Cell[45553, 1272, 539, 14, 87, "Text"],
Cell[46095, 1288, 47, 1, 48, "Input"],
Cell[46145, 1291, 303, 10, 27, "Text"],
Cell[46451, 1303, 694, 23, 62, "Text"],
Cell[47148, 1328, 401, 13, 27, "Text"],
Cell[47552, 1343, 802, 26, 62, "Text"],
Cell[48357, 1371, 856, 15, 258, "Input"],
Cell[49216, 1388, 278, 4, 82, "Input"],
Cell[49497, 1394, 620, 23, 44, "Text"],
Cell[50120, 1419, 37, 1, 48, "Input"],
Cell[50160, 1422, 348, 9, 44, "Text"],
Cell[50511, 1433, 159, 4, 65, "Input"],
Cell[50673, 1439, 566, 15, 62, "Text"],
Cell[51242, 1456, 134, 2, 80, "Input"],
Cell[51379, 1460, 629, 16, 62, "Text"],
Cell[52011, 1478, 561, 11, 132, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

